<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Order extends Model 
{

    protected $table = 'orders';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function waiter()
    {
        return $this->hasOne('App\Models\Table');
    }

    public function order_item()
    {
        return $this->hasMany('App\Models\OrderItem');
    }

}